import org.uddi4j.client.UDDIProxy;
import org.uddi4j.response.AuthToken;
import org.uddi4j.response.BusinessInfo;
import org.uddi4j.response.BusinessInfos;
import org.uddi4j.response.RegisteredInfo;
import org.uddi4j.response.TModelInfo;
import org.uddi4j.response.TModelInfos;
import org.uddi4j.transport.TransportFactory;
import java.security.Security;
import java.util.Vector;

public class UDDIGetRegisteredInfo1 {

	public static void main(String[] args) throws Exception {

		System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");      
		Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider());

		System.setProperty(TransportFactory.PROPERTY_NAME, "org.uddi4j.transport.ApacheAxisTransport");

		UDDIProxy proxy = new UDDIProxy();
		proxy.setInquiryURL("http://uddi.microsoft.com/inquire");
		proxy.setPublishURL("https://uddi.microsoft.com/publish");

		AuthToken at = proxy.get_authToken("user", "password");

		RegisteredInfo ri = proxy.get_registeredInfo(at.getAuthInfoString());

		BusinessInfos bis = ri.getBusinessInfos();
		if (bis.size() == 0) {
			System.out.println("no business(es) found");
		}
		else {
			System.out.println(bis.size()+" business(es) found\n");
			Vector biv = bis.getBusinessInfoVector();
			for (int i = 0; i < biv.size(); i++) {
				BusinessInfo bi = (BusinessInfo)biv.elementAt(i);
				System.out.println(bi.getNameString());
				System.out.println(bi.getBusinessKey());
				System.out.println("\n");
			}
		}

		TModelInfos tis = ri.getTModelInfos();
		if (tis.size() == 0) {
			System.out.println("no tmodel(s) found");
		}
		else {
			System.out.println(tis.size()+" tmodel(s) found\n");
			Vector tiv = tis.getTModelInfoVector();
			for (int i = 0; i < tiv.size(); i++) {
				TModelInfo ti = (TModelInfo)tiv.elementAt(i);
				System.out.println(ti.getNameString());
				System.out.println(ti.getTModelKey());
				System.out.println("\n");
			}
		}
		proxy.discard_authToken(at.getAuthInfo());
	}
}